/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.CSSColors;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.css.core.parsing.ast.CSSNode;
import com.aptana.css.core.parsing.ast.CSSRuleNode;
import com.aptana.css.core.parsing.ast.CSSTermNode;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class CSSFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                IParseRootNode ast = context.getAST();
                if (ast != null) {
                    this.walkNode(index, context.getURI(), (IParseNode)ast);
                }
            }
            catch (CoreException ast) {
                sub.done();
            }
            catch (Throwable e) {
                IdeLog.logWarning((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    public void walkNode(Index index, URI uri, IParseNode current) {
        CSSTermNode term;
        String value;
        if (current == null) {
            return;
        }
        if (current instanceof CSSAttributeSelectorNode) {
            CSSAttributeSelectorNode cssAttributeSelectorNode = (CSSAttributeSelectorNode)current;
            String text = cssAttributeSelectorNode.getText();
            if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '.') {
                this.addIndex(index, uri, "css.class", text.substring(1));
            } else if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '#') {
                this.addIndex(index, uri, "css.identifier", text.substring(1));
            }
        }
        if (current instanceof CSSTermNode && CSSColors.isColor(value = (term = (CSSTermNode)current).getText())) {
            this.addIndex(index, uri, "css.color", CSSColors.to6CharHexWithLeadingHash(value.trim()));
        }
        if (current instanceof CSSRuleNode) {
            CSSNode child;
            CSSRuleNode cssRuleNode = (CSSRuleNode)current;
            CSSNode[] cSSNodeArray = cssRuleNode.getSelectors();
            int n = cSSNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = cSSNodeArray[n2];
                this.walkNode(index, uri, (IParseNode)child);
                ++n2;
            }
            cSSNodeArray = cssRuleNode.getDeclarations();
            n = cSSNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                child = cSSNodeArray[n2];
                this.walkNode(index, uri, (IParseNode)child);
                ++n2;
            }
        } else {
            IParseNode[] iParseNodeArray = current.getChildren();
            int n = iParseNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IParseNode child = iParseNodeArray[n3];
                this.walkNode(index, uri, child);
                ++n3;
            }
        }
    }
}

